# -*- coding: utf-8 -*-
"""
Created on Mon Apr 19 17:50:48 2021

@author: Dyrvik
"""
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import matplotlib as mpl
import seaborn as sns
import pandas as pd
import os
from mpl_toolkits.axes_grid1 import Divider, Size
from matplotlib.patches import Patch

"""Colourmaps"""
CM_SUBSECTION_GREENS = np.linspace(0.4, 1.0, 1000) 
COLOURS_GREENS = [ cm.Greens(x) for x in CM_SUBSECTION_GREENS ]

CM_SUBSECTION_ORANGES = np.linspace(0.3, 1.0, 1000) 
COLOURS_ORANGES = [ cm.Oranges(x) for x in CM_SUBSECTION_ORANGES ]

CM_SUBSECTION_BLUES = np.linspace(0.3, 1.0, 1000) 
COLOURS_BLUES = [ cm.Blues(x) for x in CM_SUBSECTION_BLUES ]

"""File handling"""
main_folder_path = os.path.dirname(os.path.abspath(__file__))
main_folder_path = '\\\\?\\' + main_folder_path
data_folder_path = main_folder_path
export_folder_path = main_folder_path
# =============================================================================
# export_folder_name = 'Plots'
# export_folder_path = os.path.join(main_folder_path,export_folder_name)
# if not os.path.exists(export_folder_path):
#     os.mkdir(export_folder_path) # create folder if non-existent
# =============================================================================

file_name = 'key data batch 17 22.csv'
file_path = os.path.join(data_folder_path,file_name)
df_elqe = pd.read_csv(file_path) 

file_name = 'plqy-b31-for-python.csv'
file_path = os.path.join(data_folder_path,file_name)
df_plqy = pd.read_csv(file_path) 

"""Some constants for graphical settings"""
lw = 3
ticksize_major = 8
ticksize_minor = 8

"""Box swarm plot general graphic settings"""
boxcolour = COLOURS_GREENS[650]
boxprops = {'edgecolor': boxcolour, 'linewidth': lw*1.5, 'facecolor': 'w'}
lineprops = {'color': boxcolour, 'linewidth': lw*1.5}
boxplot_kwargs = dict({'boxprops': boxprops, 'medianprops': lineprops,
                       'whiskerprops': lineprops, 'capprops': lineprops,
                       'width': 0.75})

boxcolour2 = COLOURS_BLUES[400]
boxprops2 = {'edgecolor': boxcolour2, 'linewidth': lw*1.5, 'facecolor': 'w'}
lineprops2 = {'color': boxcolour2, 'linewidth': lw*1.5}
boxplot_kwargs2 = dict({'boxprops': boxprops2, 'medianprops': lineprops2,
                       'whiskerprops': lineprops2, 'capprops': lineprops2,
                       'width': 0.75})

"""Plotting the box swarm plot"""
fig = plt.figure(figsize=(7.5, 7.5))
h = [Size.Fixed(1.0), Size.Scaled(1.), Size.Fixed(.2)]
v = [Size.Fixed(0.7), Size.Scaled(1.), Size.Fixed(.5)]
divider = Divider(fig, (0, 0, 1, 1), h, v, aspect=False)
# The width and height of the rectangle are ignored.
ax_elqe = plt.axes([0.15, 0.15, 0.85, 0.85])
ax_plqy=ax_elqe.twinx()

plot_order = ['ITO', 1.6, 2.2, 3.3, 6, 11, 20]
sns.boxplot(x=df_elqe['TFB thickness [nm]'], y=df_elqe['Peak EQE [%]'], ax=ax_elqe, order=plot_order, fliersize=0, saturation=1, **boxplot_kwargs)
sns.swarmplot(x=df_elqe['TFB thickness [nm]'], y=df_elqe['Peak EQE [%]'], ax=ax_elqe, order=plot_order, color='w', edgecolor=boxcolour, linewidth=lw, size=8)

plot_order = ['ITO', '1.6', '2.2', '3.3', '6', '11', '20']
sns.boxplot(x=df_plqy['Type thickness'], y=df_plqy['Average PLQY'], ax=ax_plqy, order=plot_order, fliersize=0, saturation=1, **boxplot_kwargs2)
sns.swarmplot(x=df_plqy['Type thickness'], y=df_plqy['Average PLQY'], ax=ax_plqy, order=plot_order, color='w', edgecolor=boxcolour2, linewidth=lw, size=8)


"""Annotation"""

ax_elqe.annotate("",
            xy=(0.05, 0.55), xycoords='axes fraction',
            xytext=(0.2, 0.55), textcoords='axes fraction',
            arrowprops=dict(facecolor=boxcolour, edgecolor='none', width=lw),
            )
ax_plqy.annotate("",
            xy=(0.32, 0.3), xycoords='axes fraction',
            xytext=(0.17, 0.3), textcoords='axes fraction',
            arrowprops=dict(facecolor=boxcolour2, edgecolor='none', width=lw),
            )

"""Axis details"""
ax_elqe.set_xlabel('TFB thickness [nm]')
ax_elqe.set_ylabel('$\mathregular{EQE_{EL}}$ [%]')
ax_elqe.set_ylim(bottom=0, top=13.5)
ax_elqe.yaxis.set_major_locator(mpl.ticker.MultipleLocator(2))
ax_elqe.yaxis.set_minor_locator(mpl.ticker.MultipleLocator(1))

ax_plqy.set_ylabel('PLQY [%]')
ax_plqy.set_ylim(bottom=0, top=39)
ax_plqy.yaxis.set_major_locator(mpl.ticker.MultipleLocator(5))
ax_plqy.yaxis.set_minor_locator(mpl.ticker.MultipleLocator(2.5))

"""Legend"""
    
legend_elements = [Patch(facecolor=boxcolour, edgecolor='None',
                         label='$\mathregular{EQE_{EL}}$'),
                   Patch(facecolor=boxcolour2, edgecolor='None',
                         label='PLQY')]

ax_elqe.legend(handles=legend_elements, loc=4, frameon = False, title=False)

"""Graphical details"""
plt.rcParams['font.size'] = 24
plt.rc('axes', labelsize=30)    # fontsize of the x and y labels
plt.rcParams['axes.linewidth'] = lw
plt.rcParams['lines.linewidth'] = lw

ax_elqe.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax_elqe.xaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax_elqe.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax_elqe.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)

ax_plqy.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax_plqy.xaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax_plqy.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax_plqy.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)

"""Exporting plots"""
# =============================================================================
# plot_name = 'Plot EQEEL PLQY TFB thickness no Al2O3'
# export_name_pdf = plot_name + '.pdf'
# export_name_svg = plot_name + '.svg'
# #export_name_eps = plot_name + '.eps'
# pdf_path = os.path.join(export_folder_path,export_name_pdf)
# svg_path = os.path.join(export_folder_path,export_name_svg)
# #eps_path = os.path.join(export_folder_path,export_name_eps)
# if len(pdf_path) > 255:
#     warning_string = 'Warning: plot file path longer than 255 characters, downstream handling issues may occur. Path: ' + pdf_path
#     print(warning_string)
# fig.savefig(pdf_path, bbox_inches='tight')
# fig.savefig(svg_path, bbox_inches='tight')
# #fig.savefig(eps_path, bbox_inches='tight')
# plt.close(fig)
# =============================================================================

